import java.awt.Panel;
import java.awt.Event;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import types.DataClass;
import types.FrameBuffer;


public class BucketPanel extends Panel {
    FrameBuffer m_Buffer;
    int m_iSizeX;
    int m_iSizeY;

    public BucketPanel(FrameBuffer buffer,int iSizeX,int iSizeY) {
        m_Buffer = buffer;
        m_iSizeX = iSizeX;
        m_iSizeY = iSizeY;
    }
    public void paint(Graphics g) {
        Bucket bucket = new Bucket(m_Buffer);
        bucket.paint(g,new Rectangle(0,0,m_iSizeX,m_iSizeY));
    };
    public void myUpdate(FrameBuffer buffer) {
        m_Buffer = buffer;
        repaint();
    }
    public boolean handleEvent(Event e) {
        if (e.id == Event.MOUSE_DOWN) {
            if (Global.channel.model()==2) {
                Rectangle rahmen = bounds();
                int iMax = m_Buffer.getMaxSize();
                int iIndex = (m_iSizeY-e.y)/(m_iSizeY/iMax);
                m_Buffer.toggleFrame(iIndex);
                repaint();
            }
        }
        return(true);
    }
    public Dimension preferredSize() {
        return (new Dimension(m_iSizeX,m_iSizeY));
    };
    public Dimension minimumSize() {
        return (new Dimension(m_iSizeX,m_iSizeY));
    };

}
